<?php
namespace CLF\Inc\Core;
use CLF\Inc\Admin as Admin;
use CLF\Inc\Frontend as Frontend;
class Init{
    protected $loader;
    protected $plugin_name;
    protected $version;
    protected $plugin_basename;
    protected $plugin_text_domain;
    
    public function __construct() {
        $this->plugin_name = PLUGIN_NAME;
		$this->version = PLUGIN_VERSION;
		$this->plugin_basename = PLUGIN_BASENAME;
		$this->plugin_text_domain = PLUGIN_TEXT_DOMAIN;
       
        $this->load_dependencies();
		$this->define_admin_hooks();
        $this->define_public_hooks();
    }
    private function define_admin_hooks() {
        
            $admin = new Admin\Clever_Finance_Admin();
            // Add a settings page under WooCommerce
            $this->loader->add_action( 'admin_menu', $admin, 'add_admin_menu' );
            // Register and check the settings
            $this->loader->add_action( 'admin_init', $admin, 'register_settings' );   
    
    }
    private function define_public_hooks() {

		$plugin_public = new Frontend\Frontend( $this->get_plugin_name(), $this->get_version(), $this->get_plugin_text_domain() );

		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_styles' );
		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_scripts' );
        $this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_block_script' );
		// Add the payment gateways to WooCommerce
		$this->loader->add_filter( 'woocommerce_payment_gateways', $plugin_public, 'get_gateways' );
       
        $this->loader->add_action( 'woocommerce_blocks_loaded', $plugin_public, 'register_clever_finance_payment_methods' );

		// Register endpoint
		$this->loader->add_action( 'rest_api_init', $plugin_public, 'register_rest_route' );

		// Listen for a completed Digiteal payment
		$this->loader->add_action( 'digiteal_payment_complete', $plugin_public, 'payment_complete' );
        

        
        add_action('before_woocommerce_init', function() {
            if (class_exists('\Automattic\WooCommerce\Utilities\FeaturesUtil')) {
                \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', 'clever-finance-payments/clever-finance.php', true);
            }
        });
        add_action('before_woocommerce_init', function(){
            // Check if the required class exists
            if (class_exists('\Automattic\WooCommerce\Utilities\FeaturesUtil')) {
                // Declare compatibility for 'cart_checkout_blocks'
                \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('cart_checkout_blocks','clever-finance-payments/clever-finance.php', true);
            }
        });
        
	}
 
    public function get_plugin_name() {
		return $this->plugin_name;
	}
    public function get_version() {
		return $this->version;
	}
    public function get_plugin_text_domain() {
		return $this->plugin_text_domain;
	}
    public function get_loader() {
		return $this->loader;
	}
    private function load_dependencies() {
		$this->loader = new Loader();

	}
    public function run() {
        $this->loader->run();
    }
}