<?php

namespace CLF\Inc\Common;

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;
use CLF\Inc\Common\BasePaymentMethod;

final class CleverFinance_Blocks extends AbstractPaymentMethodType {

    protected $name = 'clever_finance'; 
    private $gateway;

    public function __construct(BasePaymentMethod $gateway) {
        $this->gateway = $gateway;
        $this->name = $gateway->title;
    }
    public function initialize() {
        
    }
    public function is_active() {
        return $this->gateway->enabled;
    }

    public function get_payment_method_script_handles() {
        wp_register_script(
            $this->gateway->title.'blocks-integration',
            plugin_dir_url(__FILE__) . '../frontend/js/clf-blocks.js',
            [
                'wc-blocks-registry',
                'wc-settings',
                'wp-element',
                'wp-html-entities',
                'wp-i18n',
            ],
            null,
            true
        );

        if (function_exists('wp_set_script_translations')) {
            wp_set_script_translations('clever-finance-blocks-integration');
        }

        return [$this->gateway->title.'blocks-integration'];
    }

    public function get_payment_method_data() {
        return [
            'title'       => $this->gateway->title,
            'description' => $this->gateway->description,
            'supports'    => [
                'products',
                'refunds',
            ],
        ];
    }
}
