document.addEventListener('DOMContentLoaded', function () {
Object.keys(window.clf_blocks_gateway_data).forEach((gatewayKey) => {
    const settings = window.clf_blocks_gateway_data[gatewayKey] || {};

    const label = window.wp.htmlEntities.decodeEntities(settings.title) || window.wp.i18n.__('Clever Finance Payment', 'clever_finance_payment');
    const Content = () => {
        return window.wp.htmlEntities.decodeEntities(settings.description || '');
    };
    
    const Block_Gateway = {
        name: gatewayKey, 
        label: label,
        content: Object(window.wp.element.createElement)(Content, null),
        edit: Object(window.wp.element.createElement)(Content, null),
        canMakePayment: () => true,
        ariaLabel: label,
        supports: {
            features: settings.supports,
        },
    };

    window.wc.wcBlocksRegistry.registerPaymentMethod(Block_Gateway);
});
});
