<?php

namespace CLF\Inc\Core;

use CLF\Inc\Admin\Clever_Finance_Admin;

/**
 * Fired during plugin deactivation
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 **/
class Deactivator {

	/**
	 *
	 * @since    1.0.0
	 */
	public static function deactivate() {
		$admin = new Clever_Finance_Admin();

		// Maybe deregister the webhook
		$admin->maybe_deregister_webhook( $settings );

		// Remove the settings
		delete_option( 'clever_finance_options' );
	}

}
