<div class="wrap container grid-lg">
    <h1 class="text-primary">Clever Finance</h1>

    <div class="toast toast-<?php echo ($this->connection_status === 'Connected') ? 'success' : 'error'; ?>">
        <strong>Status:</strong> <?php echo $this->connection_status; ?>
    </div>
    <div class="divider"></div>

    <?php if ($this->connection_status === 'Connected'): ?>
        <p><?php echo esc_html__('You are logged in to CleverFinance.', 'clever-finance-settings') ?></p>
        <p><?php echo esc_html__('You can now configure your payment methods.', 'clever-finance-settings') ?></p>
        <p><?php echo wp_kses(__('In case you need additional payment methods, please <a href="mailto:">contact Clever Finance</a>. After new payment methods are enabled, please press the save changes button to refresh your available payment methods in WooCommerce.', 'clever-finance-settings'), [
                'a' => [
                    'href' => []
                ]
            ]) ?></p>
        <a href="?page=clever-finance-settings&action=logout" class="btn btn-error"> <?php echo esc_html__('Logout', 'clever-finance-settings') ?></a>
        <div class="divider"></div>
    <?php endif; ?>

    <div class="columns">
    <form method="post" action="options.php" class="card col-12">
        <div class="card-body">
            <?php
            settings_fields('clever_finance_options');
            do_settings_sections('clever_finance_settings');
            submit_button();
            ?>
        </div>
    </form>
    </div>
</div>