<?php
/**
 * NOTICE OF LICENSE.
 *
 * CLF for PrestaShop is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/afl-3.0.php
 *
 * @author    SARL KIXELL (https://kixell.fr)
 * @copyright Copyright © 2021 - SARL Kixell
 * @license   https://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 *
 * @version   1.0.3
 */
require_once _PS_MODULE_DIR_.'/clfpayment/src/Classes/CLFLogger.php';
require_once _PS_MODULE_DIR_.'/clfpayment/src/Classes/CLFTools.php';
/**
 * Class CLFErrorModuleFrontController.
 */
class CLFErrorModuleFrontController extends ModuleFrontController
{
    public $ssl = true;

    public function postProcess()
    {
        $this->context->cookie->CLFErrors = $this->module->l('Your payment was not accepted, you can try ordering again or use another payment method.');
        CLFLogger::logInfo('[error] postProcess called');
        $cart_id = Tools::getValue('cart_id');
        $cart = new Cart((int) $cart_id);
        CLFLogger::logInfo('[error] $cart_id = '.$cart_id);
        if (Validate::isLoadedObject($cart)) {
            $order_page = CLFTools::getOrderPageFromCart($cart);
            CLFTools::CLFRedirect($order_page);
        } else {
            $order_page = Configuration::get('PS_ORDER_PROCESS_TYPE') ? 'order-opc' : 'order';
            CLFLogger::logError('[error] Cart not loaded properly, cart id : '.$cart_id);
            CLFTools::CLFRedirect('index.php?controller='.$order_page);
        }
    }
}
