{*
* NOTICE OF LICENSE
*
* CLF for PrestaShop is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* https://opensource.org/licenses/afl-3.0.php
*
* @author    SARL KIXELL (https://kixell.fr)
* @copyright Copyright © 2021 - SARL Kixell
* @license   https://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
* @package   CLF
* @version   1.0.3
*}

<div class="bootstrap">
    <div class="panel text-center">
        <img width="100" src="{$module_dir|escape:'htmlall':'UTF-8'}/views/img/CLF.svg" >
        <h1>
            Clever Finance
            <br /><small>{$CLF_description|escape:'htmlall':'UTF-8'}</small>
            {if isset($clfmode) && $clfmode == 1}
                <br /><div style="color: white;margin-top: 10px;background: #27b5c0;padding: 5px 0;">MODE TEST</div>
            {/if}
        </h1>
    </div>
    {if isset($connected)}
        <div class="panel CLF-success">
            <p>Connected</p>
        </div>
    {/if}
    {if isset($messageSuccess)}
        <div class="panel CLF-success">
            <p>{$messageSuccess|escape:'htmlall':'UTF-8'}</p>
        </div>
    {/if}
    {if isset($messageError)}
        <div class="panel CLF-alert">
            <p>{$messageError|escape:'htmlall':'UTF-8'}</p>
        </div>
    {/if}

    <div class="panel">
        <form id="configuration_form" class="defaultForm form-horizontal CLF" method="post" action="{$form_action|escape:'htmlall':'UTF-8'}">
            {foreach $inputs as $input}
                <div class="form-group">
                    {if $input.type == 'text'}
                        <label class="control-label col-lg-3">{$input.label}</label>
                        <div class="margin-form col-lg-3">
                            {if isset($input.disabled) && $input.disabled}
                                <input type="text" value="{if isset($input.value)}{$input.value}{/if}" disabled>
                                <input type="hidden" name="{$input.name}" id="{$input.name}" value="{if isset($input.value)}{$input.value}{/if}">
                            {else}
                                <input type="text" name="{$input.name}" id="{$input.name}" value="{if isset($input.value)}{$input.value}{/if}"
                                       {if isset($input.required) && $input.required}required="required"{else}{/if}>
                            {/if}
                        </div>
                        <div class="col-lg-6">
                            {if isset($input.desc)}<p class="CLF-info">{$input.desc}</p>{/if}
                        </div>
                    {elseif $input.type == 'radio'}
                        <label class="control-label col-lg-3">{$input.label}</label>
                        <div class="margin-form col-lg-3">
                            {foreach $input.values as $value}
                                <div class="radio {if isset($input.class)}{$input.class}{/if}">
                                    {strip}
                                        <label>
                                            <input type="radio"	name="{$input.name}" id="{$value.id}" value="{$value.value|escape:'html':'UTF-8'}"{if $input.value == $value.value} checked="checked"{/if}{if (isset($input.disabled) && $input.disabled) or (isset($value.disabled) && $value.disabled)} disabled="disabled"{/if}/>
                                            {$value.label}
                                        </label>
                                    {/strip}
                                </div>
                                {if isset($value.p) && $value.p}<p class="help-block">{$value.p}</p>{/if}
                            {/foreach}
                        </div>
                        <div class="col-lg-6">
                            {if isset($input.desc)}<p class="CLF-info">{$input.desc}</p>{/if}
                        </div>
                    {elseif $input.type == 'switch'}
                    <label class="control-label col-lg-3">{$input.label}</label>
                    <div class="margin-form col-lg-3">
                        <span class="switch prestashop-switch fixed-width-lg">
                            {foreach $input.values as $value}
                                <input type="radio" name="{$input.name}"{if $value.value == 1} id="{$input.name}_on"{else} id="{$input.name}_off"{/if} value="{$value.value}"{if $input.value == $value.value} checked="checked"{/if}{if (isset($input.disabled) && $input.disabled) or (isset($value.disabled) && $value.disabled)} disabled="disabled"{/if}/>
                            {strip}
                                <label {if $value.value == 1} for="{$input.name}_on"{else} for="{$input.name}_off"{/if}>
                                {if $value.value == 1}
                                    {l s='Yes'}
                                {else}
                                    {l s='No'}
                                {/if}
                            </label>
                            {/strip}
                            {/foreach}
                            <a class="slide-button btn"></a>
                        </span>
                    </div>
                    <div class="col-lg-6">
                        {if isset($input.desc)}<p class="CLF-info">{$input.desc}</p>{/if}
                    </div>
                    {elseif $input.type == 'password'}
                        <label class="control-label col-lg-3">{$input.label}</label>
                        <div class="margin-form col-lg-3">
                            <input type="password" name="{$input.name}" id="{$input.name}" value="{if isset($input.value)}{$input.value}{/if}"
                                   {if isset($input.required) && $input.required}required="required"{else}{/if}>
                        </div>
                        <div class="col-lg-6">
                            {if isset($input.desc)}<p class="CLF-info">{$input.desc}</p>{/if}
                        </div>
                    {elseif $input.type == 'hidden'}
                        <input type="hidden" name="{$input.name}" id="{$input.name}" value="{if isset($input.value)}{$input.value}{/if}">
                    {elseif $input.type == 'link'}
                        <label class="control-label col-lg-3">{$input.label}</label>
                        <div class="margin-form col-lg-3">
                            <a class="btn btn-lg btn-primary btn-block" {if isset($input.value)} href="{$input.value}"{/if} target="_blank">{$input.name}</a>
                        </div>
                        <div class="col-lg-6">
                            {if isset($input.desc)}<p class="CLF-info">{$input.desc}</p>{/if}
                        </div>
                    {elseif $input.type == 'alert'}
                        <div class="col-lg-2"></div>
                        <div class="col-lg-8">
                            {if isset($input.desc)}<p class="CLF-alert">{$input.desc}</p>{/if}
                        </div>
                        <div class="col-lg-2"></div>
                    {elseif $input.type == 'reinsurance'}
                        <div class="col-lg-2"></div>
                        <div class="col-lg-8">
                            {if isset($input.desc)}<p class="CLF-reinsurance">{$input.desc}</p>{/if}
                        </div>
                        <div class="col-lg-2"></div>
                    {elseif $input.type == 'paymentMethod'}
                        <div class="col-lg-2"></div>
                        <div class="col-lg-8">
                            <h4 class="text-left">{$input.label}</h4>
                            {foreach $input.values as $value}
                                <div style="display: inline-block; margin: 0 10px" class="text-center">
                                    <label for="{$input.name}_{$value|strtolower}">
                                        <img style="cursor:pointer;" width="100" src="{$module_dir|escape:'htmlall':'UTF-8'}views/img/{$value|strtolower}.svg">
                                    </label><br />
                                    {if isset($input.disabled) && $input.disabled}
                                    {else}
                                        <input type="checkbox" name="{$input.name}_{$value|strtolower}" id="{$input.name}_{$value|strtolower}" value="{$value|strtolower}">
                                    {/if}
                                </div>
                            {/foreach}
                        </div>
                        <div class="col-lg-2"></div>
                    {elseif $input.type == 'ibans'}
                        <div class="col-lg-2"></div>
                        <div class="col-lg-8">
                            <h4 class="text-left">{$input.label}</h4>
                            {foreach $input.values as $value}
                                <div style="text-align:left; margin: 0 10px;border: 1px solid #eeeeee;padding: 5px 15px;font-size:1.1em" class="text-center">
                                    <input type="radio" name="{$input.name}" id="{$input.name}_{$value}" value="{$value}"
                                    {if $input.selected === $value}checked{/if}>
                                    <label for="{$input.name}_{$value}" id="{$input.name}_{$value}">
                                        {$value}
                                    </label>
                                </div>
                            {/foreach}
                        </div>
                        <div class="col-lg-2"></div>
                    {/if}
                </div>
            {/foreach}


            <div class="panel-footer text-right">
                {*<a href="{$reinit_module}" class="btn btn-default pull-left">
                    <i class="process-icon-delete"></i> {l s='Reinitialize the configuration' mod='CLF'}
                </a>*}

               
                    <button formnovalidate type="submit" value="0" id="CLF_form_reinit_btn" name="{$reinit_submit}" class="btn btn-default pull-left">
                        <i class="process-icon-delete"></i> {l s='Reinitialize the configuration' mod='CLF'}
                    </button>
                
                {if isset($submit_label) &&  isset($submit_name)}
                    <button type="submit" value="1" id="configuration_form_submit_btn" name="{$submit_name}" class="btn btn-primary pull-right">
                        <i class="process-icon-next"></i> {$submit_label}
                    </button>
                {/if}
            </div>
        </form>
        {* if isset($submit_label) &&  isset($submit_name)}
        </form>
        {else}
        </div>
        {/if *}
    </div>

</div>
<div class="modal fade" id="CLF_modal_reinit" tabindex="-1" style="display: none;" aria-hidden="true">
    <div class="modal-dialog ">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">{l s='Attention' mod='CLF'}</h4>
            </div>

            <div class="modal-body">{l s='Resetting the configuration will disable the payment on your store. You will need to re-configure the module with your company information. Would you like to reset the module?' mod='CLF'}</div>

            <div class="modal-footer">
                <button type="button" class="btn btn-outline-secondary btn-lg" id="CLF-modal-cancel" data-dismiss="modal">
                    {l s='Cancel' mod='CLF'}
                </button>
                <button type="button" class="btn btn-primary btn-lg" id="CLF-modal-submit">
                    {l s='Yes, reset the module' mod='CLF'}
                </button>
            </div>
        </div>
    </div>
</div>
